/**
 * SyntaxHighlighter
 * http://alexgorbatchev.com/SyntaxHighlighter
 * 
 * @version
 * 3.0.83 (July 02 2010)
 * 
 * @copyright original
 * Copyright (C) 2004-2010 Alex Gorbatchev.
 * 
 * Advanced version by Robin Calmejane
 * http://nomadonweb.com
 * 
 * @lastedit
 * Sep 24 2013
 * 
 * @license
 * Dual licensed under the MIT and GPL licenses.
 */
;(function()
{
	// CommonJS
	typeof(require) != 'undefined' ? SyntaxHighlighter = require('shCore').SyntaxHighlighter : null;

	function Brush()
	{
		function process(match, regexInfo)
		{
			var constructor = SyntaxHighlighter.Match,
				code = match[0],
				tag = new XRegExp('(&lt;|<)[\\s\\/\\?]*(?<name>[:\\w-\\.]+)', 'xg').exec(code),
				result = [],
				attColor = 'color4',
				tagColor = 'keyword',
				valColor = 'string';
			
			if (tag != null) {
				var tgn = tag.name.toLowerCase(),
					formTags = 		['form','input','textarea','button','select','optgroup','option','label','fieldset','legend','datalist','keygen','output'],
					scriptTags = 	['script','noscript'],
					tableTags = 	['table','thead','tbody','tfoot','th','tr','td','caption','col','colgroup'],
					imgTags = 		['img','map','area','canvas','figure','figcaption'],
					objTags = 	['object','param','embed'],
					mediaTags = 	['audio','source','track','video'],
					listTags = 	['ul','ol','li','dl','dt','dd','menu','command'];
				
				if (tgn == 'a') {
					attColor = 'anchoratt';tagColor = 'anchortag';}		// link element
				if (formTags.indexOf(tgn) != -1) {
					attColor = 'formatt';tagColor = 'formtag';}			// form elements
				if (scriptTags.indexOf(tgn) != -1) {
					attColor = 'scriptatt';tagColor = 'scripttag';}		// script elements
				if (tgn == 'style') {
					attColor = 'cssatt';tagColor = 'csstag';}			// css element
				if (tableTags.indexOf(tgn) != -1) {
					attColor = 'tableatt';tagColor = 'tabletag';}		// table elements
				if (imgTags.indexOf(tgn) != -1) {
					attColor = 'imgatt';tagColor = 'imgtag';}			// image elements
				if (objTags.indexOf(tgn) != -1) {
					attColor = 'objatt';tagColor = 'objtag';}			// object elements
				if (tgn == 'meta') {
					attColor = 'metaatt';tagColor = 'metatag';}			// meta element
				if (mediaTags.indexOf(tgn) != -1) {
					attColor = 'mediaatt';tagColor = 'mediatag';}			// media elements
				if (listTags.indexOf(tgn) != -1) {
					attColor = 'listatt';tagColor = 'listtag';}			// list elements
			}
			
			if (match.attributes != null) 
			{
				var attributes,
					regex = new XRegExp('(?<name> [\\w:\\-\\.]+)' +
										'(\\s*=\\s*)' +
										'(?<value> ".*?"|\'.*?\'|\\w+)',
										'xg'),
					regexNumber = new RegExp("^[0-9-.]+$","g");

				while ((attributes = regex.exec(code)) != null) 
				{
					
					if(attributes.value.indexOf('"') == -1 && attributes.value.indexOf('\'') == -1 && true == regexNumber.test(attributes.value))
						valColor = 'digit';
					else valColor = 'string';
					result.push(new constructor(attributes.name+attributes[2], match.index + attributes.index, attColor));
					result.push(new constructor(attributes.value, match.index + attributes.index + attributes[0].indexOf(attributes.value), valColor));
				}
			}

			if (tag != null)
				result.push(new constructor(tag.name, match.index + tag[0].indexOf(tag.name), tagColor));
			
			return result;
		}
	
		this.regexList = [
			{ regex: new XRegExp('(\\&lt;|<)\\!\\[[\\w\\s]*?\\[(.|\\s)*?\\]\\](\\&gt;|>)', 'gm'),			css: 'color2' },	// <![ ... [ ... ]]>
			{ regex: SyntaxHighlighter.regexLib.xmlComments,												css: 'comments' },	// <!-- ... -->
			{ regex: new XRegExp('(&lt;|<)[\\s\\/\\?]*(\\w+)(?<attributes>.*?)[\\s\\/\\?]*(&gt;|>)', 'sg'), func: process }
		];
	};

	Brush.prototype	= new SyntaxHighlighter.Highlighter();
	Brush.aliases	= ['xml', 'xhtml', 'xslt', 'html'];

	SyntaxHighlighter.brushes.Xml = Brush;

	// CommonJS
	typeof(exports) != 'undefined' ? exports.Brush = Brush : null;
})();
