/**
 * SyntaxHighlighter
 * http://alexgorbatchev.com/SyntaxHighlighter
 * 
 * @version
 * 3.0.83 (July 02 2010)
 * 
 * @copyright original
 * Copyright (C) 2004-2010 Alex Gorbatchev.
 * 
 * Advanced version by Robin Calmejane
 * http://nomadonweb.com
 * 
 * @lastedit
 * Sep 24 2013
 * 
 * @license
 * Dual licensed under the MIT and GPL licenses.
 */
;(function()
{
	// CommonJS
	typeof(require) != 'undefined' ? SyntaxHighlighter = require('shCore').SyntaxHighlighter : null;

	function Brush()
	{
		var keywords =	'break case catch continue debugger' +
						'default delete do else false  ' +
						'finally for if in instanceof new ' +
						'null return super switch this throw ' +
						'true try typeof var void while with'
						;

		var r = SyntaxHighlighter.regexLib;
		
		this.regexList = [
			{ regex: r.multiLineDoubleQuotedString,							css: 'string' },		// double quoted strings
			{ regex: r.multiLineSingleQuotedString,							css: 'string' },		// single quoted strings
			{ regex: r.singleLineCComments,									css: 'comments' },		// one line comments
			{ regex: r.multiLineCComments,									css: 'comments' },		// multiline comments
			{ regex: /\s*#.*/gm,											css: 'preprocessor' },	// preprocessor tags like #region and #endregion
			{ regex: new RegExp(this.getKeywords(keywords), 'gm'),			css: 'keyword' },		// keywords
			{ regex: /\bfunction\b/g,		css: 'function' },
			{ regex: /\/([^\\\/\n]|\\.)+\//g,								css: 'string' }, 		// regex
			{ regex: /([+\/*=?!:|-]|(&amp;&amp;|&&|&lt;|&gt;|<|>))/g,		css: 'color5' },
			{ regex: /[\]\[(){}]/g,											css: 'spechar' },
			{ regex: /[.;,]/g,												css: 'punct' },			// punctuation
			{ regex: /\b-?[0-9]+((\.[0-9]+)+)?\b/g,							css: 'digit' }			// digit only
		];
	
		this.forHtmlScript(r.scriptScriptTags);
	};

	Brush.prototype	= new SyntaxHighlighter.Highlighter();
	Brush.aliases	= ['js', 'jscript', 'javascript'];

	SyntaxHighlighter.brushes.JScript = Brush;

	// CommonJS
	typeof(exports) != 'undefined' ? exports.Brush = Brush : null;
})();
