/**
 * SyntaxHighlighter
 * http://alexgorbatchev.com/SyntaxHighlighter
 * 
 * @version
 * 3.0.83 (July 02 2010)
 * 
 * @copyright original
 * Copyright (C) 2004-2010 Alex Gorbatchev.
 * 
 * Advanced version by Robin Calmejane
 * http://nomadonweb.com
 * 
 * @lastedit
 * Sep 24 2013
 * 
 * @license
 * Dual licensed under the MIT and GPL licenses.
 */
;(function()
{
	// CommonJS
	typeof(require) != 'undefined' ? SyntaxHighlighter = require('shCore').SyntaxHighlighter : null;

	function Brush()
	{
		function getKeywordsCSS(str)
		{
			return '\\b([a-z_]|)' + str.replace(/ /g, '(?=:)\\b|\\b([a-z_\\*]|\\*|)') + '(?=:)\\b';
		};
	
		function getValuesCSS(str)
		{
			return '\\b' + str.replace(/ /g, '(?!-)(?!:)\\b|\\b()') + '\:\\b';
		};

		var keywords =	'align-content align-items align-self alignement-adjust all anchor-point animation-delay animation-direction ' +
						'animation-duration animation-fill-mode ' +
						'animation-iteration-count animation-name animation-play-state animation-timing-function animation appearance ' +
						'ascent azimuth backface-visibility background-attachment background-clip background-color background-image ' +
						'background-origin background-position background-repeat background-size background baseline-shift bbox ' + 
						'binding bleed bookmark-label bookmark-level bookmark-state bookmark-target border-bottom-color ' +
						'border-bottom-left-radius border-bottom-right-radius border-bottom-style border-bottom-width border-bottom ' +
						'border-collapse border-color border-image-outset border-image-repeat border-image-slice border-image-source ' +
						'border-image-width border-image border-left-color border-left-style border-left-width border-left border-radius ' +
						'border-right-color border-right-style border-right-width border-right border-spacing border-style border-top-color ' +
						'border-top-left-radius border-top-right-radius border-top-style border-top-width border-top border-width border ' +
						'box-decoration-break box-shadow box-sizing break-after break-before break-inside cap-height caption-side centerline chains ' +
						'clear clip-path clip-rule color-interpolation-filters color-profile column-count column-fill column-gap column-rule-color ' +
						'column-rule-style column-rule-width ' +
						'column-rule column-span column-width columns content counter-increment counter-reset crop cue-after cue-before cue cursor ' +
						'definition-src descent direction display dominant-baseline drop-initial-after-adjust drop-initial-after-align ' +
						'drop-initial-before-adjust drop-initial-before-align drop-initial-size drop-initial-value elevation empty-cells filter flex-basis ' +
						'flex-direction flex-flow flex-grow flex-shrink flex-wrap flex float-offset float flood-color flood-opacity ' +
						'font-family font-feature-settings font-kerning font-language-override font-size-adjust ' +
						'font-size font-stretch font-style font-synthesis font-variant-alternates font-variant-caps ' +
						'font-variant-east-asian font-variant-ligatures font-variant-numeric font-variant-position font-variant ' +
						'font-weight font grid-area grid-auto-columns grid-auto-flow grid-auto-position grid-auto-rows grid-column ' +
						'grid-column-end grid-column-start grid-row grid-row-end grid-row-start grid-template grid-template-areas ' +
						'grid-template-columns grid-template-rows grid hanging-punctuation hyphens image-rendering image-resolution ' +
						'image-orientation ime-mode inline-box-align justify-content letter-spacing lighting-color line-break line-height line-stacking-ruby ' +
						'line-stacking-shift line-stacking-strategy line-stacking ' +
						'list-style-image list-style-position list-style-type list-style margin-bottom margin-left margin-right margin-top ' +
						'margin marker-offset marks mask-box-image-outset mask-box-image-repeat ' +
						'mask-box-image-slice mask-box-image-source mask-box-image-width mask-box-image mask-clip mask-image mask-origin mask-position mask-repeat ' +
						'mask-size mask-source-type mask-type mask mathline max-height max-lines max-width min-height min-width move-to nav-down nav-index nav-left ' +
						'nav-right nav-up object-fit object-position ' +
						'opacity order orphans outline-color outline-offset outline-style outline-width outline overflow-wrap overflow-x ' +
						'overflow-y padding-bottom padding-left padding-right padding-top padding page-break-after page-break-before ' +
						'page-break-inside page-policy page pause-after pause-before pause perspective-origin perspective pitch-range pitch play-during ' +
						'pointer-events presentation-level punctuation-trim quotes rendering-intent resize rest rest-after rest-before richness rotation ' +
						'rotation-point ruby-align ruby-overhang ruby-position ruby-span slope src speak-as speak-header speak-numeral speak-punctuation speak speech-rate ' +
						'stemh stemv stress string-set table-layout tab-size target target-name target-new target-position text-align-last text-align text-combine-horizontal ' +
						'text-decoration-color text-decoration-line text-decoration-skip text-decoration-style text-decoration text-emphasis ' +
						'text-emphasis-color text-emphasis-position text-emphasis-style text-height text-indent text-justify text-orientation text-outline ' +
						'text-overflow text-rendering text-shadow text-space-collapse text-transform text-underline-position text-wrap touch-action transform-origin ' +
						'transform-style transform transition-delay transition-duration transition-property transition-timing-function ' +
						'transition unicode-bidi unicode-range units-per-em vertical-align visibility voice-balance voice-duration voice-family voice-pitch ' +
						'voice-range voice-rate voice-stress voice-volume volume white-space widows word-break word-spacing ' +
						'word-wrap writing-mode z-index bottom color clip height left overflow position right size top width';

		var values =	'above absolute active alias all-scroll alphabetic alternate-reverse alternate always armenian attr aural auto-pos ' +
						'auto avoid-column avoid-page avoid-region avoid backwards balance baseline behind below bidi-override blink blur ' +
						'bolder bold border-box both braille break-all break-word brightness calc capitalize center-left center-right circle ' +
						'close-quote code col-resize collapse column-reverse compact contain content-box context-menu continuous contrast copy counters ' +
						'counter cover crisp-edges crop crosshair cross cubic-bezier cursive dashed decimal-leading-zero decimal ' +
						'default digits disabled disc dotted double drop-shadow ease-in-out ease-in ease-out ease element ellipsis embed ' +
						'embossed ew-resize extra-condensed extra-expanded fantasy far-left far-right faster fast fixed flat flex-end ' +
						'flex-start format forwards geometricPrecision georgian grayscale groove handheld hebrew help hidden hide higher ' +
						'horizontal hsla hsl hue-rotate icon inactive initial infinite inherit inline-block inline-table inline inset inside ' +
						'invert isolate italic justify keep-all landscape left-side leftwards level lighter lime line-through list-item local ' +
						'lower-alpha lower-greek lower-latin lower-roman lowercase ltr manual marker matrix3d matrix medium menu message-box ' +
						'middle mix move n-resize narrower ne-resize nesw-resize no-close-quote no-drop no-open-quote no-repeat none ' +
						'normal not-allowed nowrap ns-resize nw-resize nwse-resize oblique once opacity open-quote optimize-contrast ' +
						'optimizeLegibility optimizeQuality optimizeSpeed outset outside overline padding-box page painted paused pointer ' +
						'portrait preserve-3d pre-wrap pre-line print progress projection radial-gradient recto rect region relative ' +
						'repeating-linear-gradient repeat-x repeat-y reverse rgb rgba ridge right-side rightwards rotate3d rotateX ' +
						'rotateY rotateZ rotate round row-resize row-reverse rtl run-in running s-resize saturate scale3d scaleX scaleY ' +
						'scaleZ scale screen scroll se-resize semi-condensed semi-expanded separate sepia show silent skewX skewY skew slower ' +
						'slow small-caps small-caption smaller solid space-around space-between space speech spell-out square start static ' +
						'status-bar step-start step-stop steps stretch stroke super sw-resize table-caption table-cell table-column-group ' +
						'table-column table-header-group table-footer-group table-row-group table-row table teal text-top text-bottom thick ' +
						'thin translate3d translateX translateY translateZ translate transparent tty tv ultra-condensed ultra-expanded ' +
						'underline under upper-alpha upper-latin upper-roman uppercase url visiblePainted visibleFill visibleStroke visible ' +
						'verso vertical-text vertical w-resize wait wavy webkit-box wider wrap-reverse wrap x-fast x-high xx-large x-large x-loud x-low ' +
						'x-slow xx-small x-small x-soft all block bottom caption cell center close-quote column condensed e-resize end ' +
						'expanded fill high larger large left loud lower low pre linear-gradient linear repeat right row small soft sub text top' + // Below : CSS 3 colors
						'aliceblue antiquewhite azure beige bisque blanchedalmond blueviolet brown burlywood cadetblue chartreuse chocolate ' +
						'cornflowerblue cornsilk crimson darkblue darkcyan darkgoldenrod darkgray darkgreen darkgrey darkkhaki darkmagenta ' +
						'darkolivegreen darkorange darkorchid darkred darksalmon darkseagreen darkslateblue darkslategray darkslategrey ' +
						'darkturquoise darkviolet deeppink deepskyblue dimgray dimgrey dodgerblue firebrick floralwhite forestgreen fuchsia ' +
						'gainsboro ghostwhite greenyellow honeydew hotpink indianred indigo ivory khaki lavender lavenderblush lawngreen ' +
						'lemonchiffon lightblue lightcoral lightcyan lightgoldenrodyellow lightgray lightgreen lightgrey lightpink lightsalmon ' +
						'lightseagreen lightskyblue lightslategray lightslategrey lightsteelblue lightyellow limegreen linen magenta maroon ' +
						'mediumaquamarine mediumblue mediumorchid mediumpurple mediumseagreen mediumslateblue mediumspringgreen mediumturquoise ' +
						'mediumvioletred midnightblue mintcream mistyrose moccasin navajowhite navy oldlace olivedrab orangered orchid ' +
						'palegoldenrod palegreen paleturquoise palevioletred papayawhip peachpuff peru pink plum powderblue purple rosybrown ' +
						'royalblue saddlebrown salmon sandybrown seagreen seashell sienna silver skyblue slateblue slategray slategrey ' +
						'snow springgreen steelblue tan teal thistle tomato turquoise violet wheat whitesmoke yellowgreen aquamarine aqua ' +
						'black blue coral cyan goldenrod gold gray green grey lime olive orange red white yellow';
		
		var fonts =		'[mM]onospace [tT]ahoma [vV]erdana [aA]rial [hH]elvetica [sS]ans-serif [sS]erif [cC]ourier mono sans serif';
		
		var statements		= '!important !default';
		var preprocessor	= '@import @extend @debug @warn @if @for @while @mixin @include';
		
		var r = SyntaxHighlighter.regexLib;
		
		this.regexList = [
			{ regex: r.multiLineCComments,								css: 'comments' },		// multiline comments
			{ regex: r.singleLineCComments,								css: 'comments' },		// singleline comments
			{ regex: r.doubleQuotedString,								css: 'string' },		// double quoted strings
			{ regex: r.singleQuotedString,								css: 'string' },		// single quoted strings
			{ regex: /\#[a-fA-F0-9]{3,6}/g,								css: 'value' },			// html colors
			{ regex: /\b(-?\d+)(\.\d+)?(px|em|pt|ms|s|ex|ch|rem|in|cm|mm|pc|deg|turn|grad|rad|vh|vw|vmax|vmin|\:|\%|)(?=([^{]|\\.)+[}])/gm,	css: 'value' },		// sizes
			{ regex: /\$\w+/g,											css: 'variable' },		// variables
			{ regex: new RegExp(this.getKeywords(statements), 'g'),		css: 'color3' },		// statements
			{ regex: new RegExp(this.getKeywords(preprocessor), 'g'),	css: 'preprocessor' },	// preprocessor
			{ regex: new RegExp(getKeywordsCSS(keywords), 'gm'),		css: 'keyword' },		// keywords
			{ regex: new RegExp(getValuesCSS(values), 'g'),				css: 'value' },			// values
			{ regex: /[{}]/g,											css: 'spechar' },
			{ regex: /[;,:](?=([^{]|\\.)+[}])/g,						css: 'punct' },		// punctuation
			{ regex: /[)(](?=([^{]|\\.)+[}])/g,							css: 'value' },
			{ regex: new RegExp(this.getKeywords(fonts), 'g'),			css: 'color1' }			// fonts
			];
	};

	Brush.prototype	= new SyntaxHighlighter.Highlighter();
	Brush.aliases	= ['sass', 'scss'];

	SyntaxHighlighter.brushes.Sass = Brush;

	// CommonJS
	typeof(exports) != 'undefined' ? exports.Brush = Brush : null;
})();
